#ifndef commif_t_h
#define commif_t_h



class CommIF
{
	public:	

	static void InterpretUART(volatile unsigned char data[37]);	// Interpret the UART receiving
	static void SendData(volatile unsigned char Bytes[40]);		// Sends 37 Bytes to UART2	
	static void SendShot(void);					// Sends Screen Shot to PC	
	static void SendSWShot(void);					// Sends Screen Shot to PC		
	static void SendLayer(unsigned char LayerNr);			// Send a Layer through USB
	static void SendCtrlBlock(void);                                // Send the ctrl block through USB
	static void SendCtrlBlock2(void);                               // Send the ctrl block 2 through USB	
	static void SendCtrlBlock3(void);                               // Send the ctrl block 3 through USB		
	
	static void Transfer_USB_Data(void);				//BF added

	static void SCREENSHOT(unsigned char marker); 			// nevm/BF
	static void DUMPCSV(unsigned char marker);			// dl3daz/BF

	// OS compatibility
	static void OS_SCREENSHOT_BW(void); 				// nevm
	static void OS_SCREENSHOT(void); 				// nevm
	static void OS_DUMPCSV(void); 					// dl3daz
	static void OS_Init_csv_dump(void);
	static void OS_Dump_csv_chan(void);
	static void OS_Finish_csv_dump(void);

	static void Set_Analog_Inputs (unsigned char *);
	static void set_vars (unsigned char *, char);
	static int handleInChar(unsigned char);
	static void handle_extended_command(unsigned char *);

	static void ON_UART2DataBlock(volatile unsigned char *);
	static void ON_Command(volatile unsigned char *);
	static void ON_WriteFlash(volatile unsigned char *);
	static void ON_ReadFlash(volatile unsigned char *);
	static void ON_TestFunction(volatile unsigned char *);




};

#endif

